////////////////////////////////////////////////////
// Siebel Systems, Inc.
////////////////////////////////////////////////////

/////////////////////////////
// Personalization Editor  //
/////////////////////////////
function PersonalizationEditor()
{
}

PersonalizationEditor.openNameDialog = function(eid, bShared, event)
{
	var tSaveSelectionEditor = new SaveSelectionEditor(eid,bShared);
	var tDialog = new XUIDialog(eid,tSaveSelectionEditor,null);

	tDialog.show(null,event.clientX,event.clientY);

	return false;
}

// page can be empty, in which case we don't want to show the save menu.  We don't want server to read all
// the pages out of the catalog to see if they are empty when rendering the menu, so we'll check here.
PersonalizationEditor.InitPageOptionsMenu = function(event, tMenu)
{
   // if there is no go form, the page is empty
   if (!document.forms["GoForm"])
   {
      // hide it
      var tA = document.getElementById('idSaveSelectionsMenuItem');
      if (tA != null)
         tA.style.display = 'none';

      tA = document.getElementById('idApplySavedSelectionsMenuItem');
      if (tA != null)
         tA.style.display = 'none';
         
      tA = document.getElementById('idClearMySelectionsMenuItem');
      if (tA != null)
         tA.style.display = 'none';
         
      tA = document.getElementById('idClearAllSelectionsMenuItem');
      if (tA != null)
         tA.style.display = 'none';
         
      tA = document.getElementById('idLinkToThisPage');
      if (tA != null)
         tA.style.display = 'none';
      
      tA = document.getElementById('idGetPURL');
      if (tA != null)
         tA.style.display = 'none';
   }
}
PersonalizationEditor.loadSelection = function(sPath,sPageIdentifier)
{
   //alert(sPageIdentifier);
   saw.clearActiveMenu();

   var tForm = document.forms["ViewForm"];
   if (tForm != undefined)
   {
      var sUrl = saw.commandToURL("Dashboard") + "&SelectionPath=" + saw.encodeURIComponent(sPath);
      sUrl += "&PortalPath=" + saw.encodeURIComponent(tForm.PortalPath.value);
      sUrl += "&Page=" + saw.encodeURIComponent(tForm.Page.value);
      sUrl += "&PageIdentifier=" + saw.encodeURIComponent(sPageIdentifier);

      saw.runThisURL(sUrl);
   }
   
   return false;
}

var g_bSavedSelsLoaded = false;
var g_bSavedSelsLoadAttempted = null;

PersonalizationEditor.getSavedSelectionsMenu = function()
{
    var d = new Date();
    
    // don't make reattempt for 2 seconds
   if(g_bSavedSelsLoaded || (g_bSavedSelsLoadAttempted != null && (d - g_bSavedSelsLoadAttempted) < 2))
   {
        return;
   }
   
   g_bSavedSelsLoadAttempted = d;
   
   var tFrame = document.getElementById("idSaveSelectionsFrame");
   var tPageIDDiv = document.getElementById("idPageID");

   if (!tPageIDDiv)
      return;

   if(!tFrame)
		tFrame = saw.createHiddenIFrame("idSaveSelectionsFrame","idSaveSelectionsFrame");

   var tViewForm = document.forms["ViewForm"];

   var sUrl = saw.commandToURL("GetSelectionsMenus")
   sUrl += "&PortalPath=" + saw.encodeURIComponent(tViewForm.PortalPath.value);
   sUrl += "&Page=" + saw.encodeURIComponent(tViewForm.Page.value);
   sUrl += "&PageIdentifier=" + saw.encodeURIComponent(tPageIDDiv.getAttribute("pageID"));

   tFrame.src = sUrl;
}

PersonalizationEditor.resetSavedSelectionsMenu = function()
{
    g_bSavedSelsLoaded = false;
    g_bSavedSelsLoadAttempted = false;
}

// If bAll is true, clear both shared and personal defaults

PersonalizationEditor.removeDefaultSelection = function(bAll)
{
   saw.clearActiveMenu();

   var tForm = document.forms["ViewForm"];
   if (tForm != undefined)
   {
      var sUrl = saw.commandToURL("Dashboard");
      sUrl += "&PortalPath=" + saw.encodeURIComponent(tForm.PortalPath.value);
      sUrl += "&Page=" + saw.encodeURIComponent(tForm.Page.value);
      if (bAll)
         sUrl += "&NoSelection=true";
      else
         sUrl += "&NoSelection=my";

      saw.runThisURL(sUrl);
   }
   
   return false;
}
/////////////////////////////////////////////////////
// Save Selection Dialog Box
/////////////////////////////////////////////////////
function SaveSelectionEditor(eid,bShared)
{
	this.form = document.forms[eid + 'Form'];

	var tPermissionsButton = document.getElementById(eid + 'ExtraButtonSpan');

	if(bShared)
		tPermissionsButton.style.display = 'inline';
	else
		tPermissionsButton.style.display = 'none';

	this.bShared = bShared;
}

SaveSelectionEditor.prototype = new XUIEditor();

SaveSelectionEditor.toMixedCase = function(sVal)
{
   var sNewVal = "";
   var ksSeps = " ,/()[].";

   var bUp = true;
   for (var c = 0; c < sVal.length; c++)
   {
      if (ksSeps.indexOf(sVal.charAt(c)) >= 0)
      {
         bUp = true;
         sNewVal += sVal.charAt(c);
      }
      else if (bUp)
      {
         sNewVal += sVal.substr(c,1).toUpperCase();
         bUp = false;
      }
      else
      {
         sNewVal += sVal.substr(c,1).toLowerCase();
         bUp = false;
      }
   }

   return sNewVal;
}

SaveSelectionEditor.truncate = function(sVal, nMax)
{
   if (sVal.length > nMax)
      sVal = sVal.substr (0, nMax-3) + "...";

   return sVal;
}

SaveSelectionEditor.prototype.load = function(xmlElement)
{
	saw.clearActiveMenu();
	
	// Try to come up with a name for this thing.  We'll default to empty.
	var knMaxLength = 70;
	var knFieldMax = 25;
	var sNewName = "";
	try
	{
	   // Find a global prompt
	   var tSpans = document.body.getElementsByTagName("SPAN");
	   for (var iSpan = 0; iSpan != tSpans.length; ++iSpan)
	   {
	      var tSpan = tSpans[iSpan];
	      if (tSpan.className == "GFPControl")
	      {
	         var tField = tSpan.firstChild;
	         if (tField == null)
	            continue;

	         if (tField.tagName == 'NOBR')
	         {
	            tField = tField.firstChild;
	            if (tField == null)
	               continue;
	         }

	         switch (tField.tagName)
	         {
	            case 'SELECT':
	               var tOpt = tField.options[tField.selectedIndex];
	               if ((tOpt.innerHTML != "") && (tOpt.value.indexOf("*)nq") < 0)) // *)nq prefix indicates all chices or none, etc.
	               {
	                  if (sNewName.length > 0)
	                     sNewName += " - ";
   	               sNewName += tOpt.innerHTML;
   	            }
	               break;
	            case 'INPUT':
	               if ((tField.value != "") && (tField.value != "%"))
	               {
	                  // strip quotes for multiselect
	                  var sStripped = tField.value.replace(/\'/g, "");

	                  if (sNewName.length > 0)
	                     sNewName += " - ";
   	               sNewName += SaveSelectionEditor.truncate(sStripped, knFieldMax);
   	            }
	               break;
	            default:
	               break;
	         }

	         if (sNewName.length > knMaxLength)
	            break;
	      }
	   }

	}
	catch (e)
	{
	   // No biggie, you pick a name
	}

   sNewName = SaveSelectionEditor.truncate(sNewName, knMaxLength);

	this.form.SelectionName.value = SaveSelectionEditor.toMixedCase(sNewName);
   this.form.SelDfltCheck.checked = false;
   this.form.Action.value = "";
}

SaveSelectionEditor.prototype.focus = function(xmlElement)
{
	this.form.SelectionName.focus();
	if (this.form.SelectionName.value.length > 0)
	   this.form.SelectionName.select();
}

SaveSelectionEditor.prototype.apply = function()
{
	if (this.form.SelectionName.value == "")
	{
		this.focus();
		return false;
	}

	var tFrame = document.getElementById("idSaveSelectionsFrame");
	var tViewStateDiv = document.getElementById("idViewStateDiv");

	if(!tFrame)
		tFrame = saw.createHiddenIFrame("idSaveSelectionsFrame","idSaveSelectionsFrame"); // look like the id and name has to be the same if removeIFrame is going to be called.

	this.form.target = "idSaveSelectionsFrame";
	this.form.action = saw.commandToURL("SaveSelections");

	var tViewForm = document.forms["ViewForm"];

	this.form.PortalPath.value = tViewForm.PortalPath.value;
	this.form.Page.value       = tViewForm.Page.value;
	this.form.ViewState.value  = tViewStateDiv.getAttribute("stateID");
	if(this.bShared)
		this.form.isShared.value = "on";
	else
		this.form.isShared.value = "off";

	this.form.submit();
	return true;
}

SaveSelectionEditor.prototype.onChildApply = function(childEditor)
{
	if(childEditor == this.ConfirmDialogEditor)
	{
		this.form.Action.value = 'overwrite';
		this.apply();

	}
	else
		this.form.PermissionsXml.value = childEditor.element.xml;
}

//-------------------
SaveSelectionEditor.confirmSaveSelection = function(eid)
{
	var tFrame = saw.getFrameWindowByName("idSaveSelectionsFrame");

	var tSaveDoneForm = tFrame.document.forms["SaveDoneForm"];

	if(tSaveDoneForm.Success.value == 'confirm')
	{
		var tSaveSelectionEditor = XUIPanel.getEditor(eid);

		var tYesNoEditor = new SelectionConfirmSaveEditor();
		var tDialog = new XUIDialog('idSelectionConfirmSave',tYesNoEditor,tSaveSelectionEditor);

		tSaveSelectionEditor.ConfirmDialogEditor = tYesNoEditor;

		tDialog.show(null,-1,-1);
	}
	else // alert the error
		alert(tSaveDoneForm.ErrorMsg.value);
}

//-------------------
SaveSelectionEditor.loadSavedSelectionMenu = function()
{
   var tFrame = saw.getFrameWindowByName("idSaveSelectionsFrame");
   if (!tFrame)
      return;

   var tOldMenu = document.getElementById("idSavedSelectionsMenu");
   var tNewMenu = tFrame.document.getElementById("idSavedSelectionsMenu");
   if (tNewMenu && tOldMenu)
   {
      tOldMenu.innerHTML = tNewMenu.innerHTML;
      saw.menuPrivs.populateMenuItems(tOldMenu);
      saw.menuPrivs.focusMenuItem(tOldMenu, 0);
      saw.menu.reposition(tOldMenu, document.getElementById('idApplySavedSelectionsMenuItem'));
   }

   g_bSavedSelsLoaded = true;

   saw.removeIFrame("idSaveSelectionsFrame");
}

SaveSelectionEditor.showSavedSelectionPermissionDialog = function(eid, event, bAllowAssignment)
{
	var tSaveSelectionEditor = XUIPanel.getEditor(eid);

	var tEditor = new SavedSelectionPermissionsEditor('idSelsPermissionsDlg');
	var tDialog = new XUIDialog('idSelsPermissionsDlg', tEditor,tSaveSelectionEditor);

 	// RIE: what we are doing here is creating an empty permissions list.
	// as XUICreateElement will add to the island a new node everytime.
	// var tXmlNode = XUICreateElement(saw.xml.kSawdNamespace, 'savedSelection');
	var tXmlNode = XUIForceSingleNode(saw.getXmlIsland(),saw.xml.kSawdNamespace, 'savedSelection');
	
	//XUIReplaceOrAppendChild(saw.getXmlIsland(), tXmlNode);
	
	if (bAllowAssignment == false)
	   XUISetAttributeBool(tXmlNode, "defaultsDisabled", true);

	tDialog.show(tXmlNode, event.clientX, event.clientY);
}

///////////////////////////////////////////////////////////////
// Yes No Editor
function SelectionConfirmSaveEditor()
{
}

SelectionConfirmSaveEditor.prototype = new XUIEditor();

SelectionConfirmSaveEditor.prototype.apply = function()
{
	return true;
}